#!/bin/bash

# 检查是否是 root 用户
if [ "$EUID" -ne 0 ]; then
  echo "请使用 root 权限运行此脚本"
  exit 1
fi

# 设置 swap 大小（单位：G）
SWAP_SIZE=2

# 创建 swap 文件
echo "正在创建 ${SWAP_SIZE}G 的 swap 文件..."
fallocate -l ${SWAP_SIZE}G /swapfile || dd if=/dev/zero of=/swapfile bs=1M count=$((SWAP_SIZE * 1024))

# 设置权限
chmod 600 /swapfile

# 格式化为 swap
mkswap /swapfile

# 启用 swap
swapon /swapfile

# 添加到 /etc/fstab 实现开机自动挂载
grep -q '^/swapfile' /etc/fstab || echo '/swapfile none swap sw 0 0' >> /etc/fstab

# 优化 swap 策略
echo 'vm.swappiness=10' >> /etc/sysctl.conf
sysctl -p

# 显示结果
echo "Swap 已成功添加。当前 swap 信息如下："
swapon --show
free -h