#!/usr/bin/env bash
# install_l4d2_plugins.sh
# 自动安装 Left 4 Dead 2 必选插件脚本（Ubuntu, Bash）

set -euo pipefail

# 检查 rsync 并安装
if ! command -v rsync >/dev/null 2>&1; then
    echo "检测到未安装 rsync，正在安装..."
    apt-get update
    apt-get install -y rsync
fi

# 当前工作目录为 ~/l4d2
WORKDIR="$(pwd)"
# 源目录：整合包中的 JS-MODS
SRC_DIR="$WORKDIR/2025-5-11豆瓣酱な (v1.11)(6968-1155)战役整合包/JS-MODS"
# 目标目录：游戏根目录（包含 addons、cfg 等子目录）
TARGET_DIR="$WORKDIR"

# 合并拷贝目录函数
copy_dir() {
    local src="$1"
    local dst="$2"
    if [ -d "$src" ]; then
        echo "合并：$src -> $dst"
        rsync -av --no-perms --no-owner --no-group "$src/" "$dst/"
    fi
}

# 确保目标子目录存在
mkdir -p "$TARGET_DIR/addons"
mkdir -p "$TARGET_DIR/cfg"

# 1. 先安装 1.11 插件平台（Linux 版）
PLATFORM_DIR="$SRC_DIR/1.11插件平台linux版(6968-1155)(必须先启用这个)/left4dead2"
if [ -d "$PLATFORM_DIR" ]; then
    echo "安装插件平台：$PLATFORM_DIR"
    copy_dir "$PLATFORM_DIR/addons" "$TARGET_DIR/addons"
    copy_dir "$PLATFORM_DIR/cfg" "$TARGET_DIR/cfg"
fi

# 2. 遍历“必选-”开头的插件文件夹
for plugin in "$SRC_DIR"/必选-*; do
    [ -d "$plugin/left4dead2" ] || continue
    echo "处理插件：$(basename "$plugin")"
    # 拷贝 addons 下内容到目标 addons 合并
    copy_dir "$plugin/left4dead2/addons" "$TARGET_DIR/addons"
    # 拷贝 cfg 下内容到目标 cfg 合并
    copy_dir "$plugin/left4dead2/cfg" "$TARGET_DIR/cfg"
done

# 提示完成
echo "所有必选插件及平台已安装完成！"